/* Sesi?n 2 */ 

/*
Lectura de datos 

I UTILIZACI?N DE BASES DE DATOS EN FORMATO SAS (*.SAS7BDAT) 

  1.1 Como acceder a bases de datos en formato SAS desde un BLOC DATA 
  1.2 Como acceder a bases de datos en formato SAS desde un BLOC PROC 

II IMPORTACI?N/EXPORTACI?N FORMATOS EXCEL, SPSS, ACCESS, SPSS ... 

  2.1 IMPORTACI?N DE DATOS EN OTROS FORMATOS (EXCEL, SPSS ...) 
  2.2 EXPORTACI?N DE DATOS SAS A OTROS FORMATOS (EXCEL, SPSS ...) 

*/ 

 

*I UTILIZACI?N DE BASES DE DATOS EN FORMATO SAS (*.SAS7BDAT); 

/*1.1 Como acceder a bases de datos en formato SAS desde un BLOC DATA*/ 

*Una librer?a es simplemente un link que se establece desde SAS a una ruta f?sica en el disco; 
*El usuario puede definir sus propias librer?as utilizando el comando LIBNAME; 
 
LIBNAME libref 'k:\ruta'; 

*libref es un nombre que el usuario decide max 8 caracteres (el que quieras), y 'k:\ruta' es la estructura 
de carpetas que quieres vincular con SAS; 

libname carpeta 'd:\CURSAS16_17\S02\dades s02\'; 

*1 Mensaje en el Log 

NOTE: Libref CARPETA was successfully assigned as follows: 
Physical Name: d:\CURSAS16_17\S02\; 

*2 En la ventana explorer os debe aparecer una librer?a con el nombre que le hab?is dado; 

/*En una misma sesi?n puede ser necesario ejecutar m?s de un comando LIBNAME depender? de donde 
est?n las bases de datos que necesitemos utilizar y de donde las queramos crear

LIBNAME libref ?k:\ruta?; 
LIBNAME libref2 ?k:\ruta2?; 
LIBNAME librefj ?k:\rutaj?;*/ 

/*Sintaxis del BLOC DATA con libref*/ 

DATA libref.nombre_nueva_base [(opciones)]; /*las bases que se van a crear*/ 
SET libref.nombre_ base_existente [opciones]; /*Las bases que ya est?n creadas*/ 
/*m?s comandos;*/ 
RUN; 


*ejemplo a partir de la base Girona.sas7bdat voy a crear una base nueva en 
la misma ruta que ser? Girona_red.sas7bdat (solo quiero las 20 primeras observaciones); 

data carpeta.girona_red; /*esta es la base que se crear?*/ 
set carpeta.girona (obs = 20) ; /*esta es la que entra (ya existe)*/ 
run; 

/*log 

There were 20 observations read from the data set E.GIRONA. 
NOTE: The data set CARPETA.GIRONA_RED has 20 observations and 3 variables*/ 

*Otra posibildad es hacerlo como:; 


data 'd:\CURSAS16_17\S02\dades s02\girona_red'; 
set 'd:\CURSAS16_17\S02\dades s02\girona' (obs = 20); 
run; 

/*Pero dado que SAS en realidad, hagamos lo que hagamos, internamente solo trabaja con librer?as 
y no en todos los procs nos deja hacer una especificaci?n en la forma de 'd:\CURSAS16_17\S02\girona_red' 
es preferible trabajar con librer?as. 

/*1.2 Como acceder a bases de datos en formato SAS desde un BLOC PROC*/ 

/*LIBNAME libref 'k:\ruta';*/

PROC nomprocedimiento 
DATA = libref.nombre_bdd_existente [(opciones)]; 
/*COMANDOS DEL PROC*/
RUN;

*Ejemplo utilizamos Girona.sas7bdat para listar las primeras 10 observaciones; 

proc print data = carpeta.girona (obs =10); 
run; 


/*2 OPCIONES DE LOS SAS DATA SETS -BASES DE DATOS SAS 

Estas opciones tienen su equivalente en comandos, pero las opciones son mucho m?s flexibles y 
adem?s las podemos utilizar tambi?n en los PROCS en cambio, los comandos solo se pueden utilizar 
en los BLOCS DATA. 

-ELIMINAR O SELECCIONAR VARIABLES 
 DROP = listvar --> no se incluye la lista de variables especificada 
 KEEP = listvar --> el fichero mantendr? la lista de variables especificada 

-SELECCI?N DE OBSERVACIONES --> SIN CONDICI?N 
 OBS = N1 --> LEE LAS N1 PRIMERAS OBSERVACIONES 
 FIRSTOBS = N2 --> LEE DESDE LA FILA N2 HASTA EL FINAL 

-SELECCI?N DE OBSERVACIONES -->CON CONDICI?N 
 WHERE = (condici?n) 
 En las condiciones se pueden utilizar operadores de comparaci?n 
 < (LT) <= (LE) = (EQ) > (GT) >= (GE) ~= (NE) i tamb? ^= (NE) 
 L?gicos AND (&) OR (|) NOT (^ o ~ ) 
 Aritm?ticos +, -, *, /, ** 

-RENOMBRAR VARIABLES 
 RENAME = (nombre_ant = nombre_nuevo ) 

-IN = var_temporal --> ?til en la uni?n de ficheros 

-Prioridad en la utilizaci?n de estas opciones 
  1 KEEP|DROP 
  2 RENAME 
  3 WHERE 

Todas las opciones excepto firstobs y obs se pueden utilizar tanto en ficheros de entrada como 
de salida y tambi?n se pueden utilizar en los PROCS 

*/ 


/*EX1 

A partir de la base CLASS.SAS7BDAT que tenemos en la librer?a SASHELP vamos a crear una base 
temporal EX1 solo con los casos que sean hombres con m?s de 60 en la variable HEIGHT 

La variable HEIGHT queremos que se llame ALTURA en la nueva base y adem?s en la base que vamos a 
crear solo queremos las variables NAME, HEIGHT=ALTURA, y AGE*/ 

 data ex1 (drop = weight sex); 
 set sashelp.class (where = (sex ='M' and altura >60) rename = (height = altura)); 
 run; 

 proc contents data = ex1; run; 

* Proc contents 

  Informa de manera r?pida y veraz de lo que hay en la bdd SAS sin necesidad de incorporarla en memoria 
  N?mero de observaciones 
  N?mero de variables
  Nombre y tipos de variables, etiquetas de variables y de valores si los hay y posici?n que 
  ocupan las variables en el fichero;

* LIBRERIAS SAS. Tipos de archivos SAS 

 TABLES -->SAS data sets .*.sas7bdat 
 CATALOGS --> (gr?ficos, etiquetas ...) .*.sas7bcat 
  ...
  ; 


/*EX2 

Crear EX2 -temporal solo con la variable SEX cambiando el nombre a GENERO y una nueva 
variable con valores x1 = 1 si es hombre-male- 0 si es mujer-female-;*/ 


* VERSI?N 1 Renombramos en el fichero de entrada -ALERTA con las prioridades 

  KEEP|DROP Prioridad 1 
  RENAME Prioridad 2 
  WHERE Prioridad 3; 

 data ex2; 
 set sashelp.class (rename = (sex = genero)); 
 X1 = (genero= 'M'); /*SELECCI?N CON LA VARIABLE YA RENOMBRADA*/ 
 run; 
 

* VERSI?N 2 Renombramos en el fichero de salida -m?s c?modo si se puede; 

data ex2 (rename = (sex = genero)); 
set sashelp.class ; 
X1 = (SEX= 'M'); 
run; 


*Obtener la distribuci?n de frecuencias de la variable X1; 

PROC FREQ DATA = EX2; 
TABLE X1; 
RUN; 

 
/*EX3 

A partir la base P1 que se crea en el siguiente bloque, crear la base temporal P2 solo con la 
variable total = x1+x2+x3;*/ 

data p1; 
input(x1-x3)(1.); 
datalines; 
123 
111 
234 
101 
; 

data p2; set p1; 
total=x1+x2+x3; 
keep total; 
run;
 

/*EX4 

Crear class0 -temporal a partir de SASHELP.CLASS CLASS0 ha de tener las variables SEX, AGE 
y HEIGHT cambiando el nombre por GENERO, EDAD y ALTURA y seleccionar solo los casos 
correspondientes a los hombres*/ 

data class0 (rename = (sex=genero age=edad height=altura));
set sashelp.class (where = (sex ='M'));  
run;

 
/*EX5 Crear class1 -temporal a partir de SASHELP.CLASS 

 CLASS1 ha de tener las variables SEX, AGE y HEIGHT cambiando el nombre por GENERO, EDAD y ALTURA 
pero solo los casos correspondientes a un valor de AGE = 12*/ 

data class1 (rename = (sex=genero age=edad height=altura));
set sashelp.class (where = (AGE=12));  
run;


/*
II IMPORTACI?N/EXPORTACI?N FORMATOS EXCEL, SPSS, ACCESS, SPSS ... 

  2.1 IMPORTACI?N DE DATOS EN OTROS FORMATOS (EXCEL, SPSS ...) 
  2.2 EXPORTACI?N DE DATOS SAS A OTROS FORMATOS (EXCEL, SPSS ...) 
*/

/* 2.1 IMPORTACI?N DE DATOS EN OTROS FORMATOS (EXCEL, SPSS ...)
  /*Asistente de importaci?n --> Teclear DIMPORT desde la casilla de comandos de la parte superior izquierda 
  Paso 1
  Paso 2
  Paso 3
  Paso 4
  o tambi?n pod?is hacer ARCHIVO / IMPORTAR DATOS


/*EX6 

   Importaci?n de la informaci?n disponible en una hoja de un archivo Excel creando una base temporal
   Importar la informaci?n de archivo mond2.xls creando la base temporal mond2;

*/

PROC IMPORT OUT= WORK.mond2 
            DATAFILE= "C:\Users\ana.maria.perez.mari\Desktop\tema2\dades s02\mond2.xls" 
            DBMS=XLS REPLACE;
     GETNAMES=YES;
RUN;


*Ex7 El fichero VICTI.TXT es un fichero delimitado por tabuladores. Importar la informaci?n de victi.txt
     a la base d:\CURSAS16_17\S02\dades s02\victi.SAS7BDAT;


PROC IMPORT OUT= e.victi 
            DATAFILE= "C:\Users\ana.maria.perez.mari\Desktop\tema2\dades s02\Victi.txt" 
            DBMS=TAB REPLACE;
     GETNAMES=YES;
     DATAROW=2; 
RUN;


/* 2.2 EXPORTACI?N DE DATOS SAS A OTROS FORMATOS (EXCEL, SPSS ...)*/

 /*Asistente de Exportaci?n --> Teclear DEXPORT desde la casilla de comandos de la parte superior izquierda
  Paso 1
  Paso 2
  Paso 3
  Paso 4
  o tambi?n pod?is hacer ARCHIVO / EXPORTAR DATOS


*Ex8 (Ejercicio 3 pdf) 


